<?php
/**
 * 'popup_anything' Shortcode
 * 
 * @package Popup anything on click
 * @since 1.0.0
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

function popupaoc_popup_anything_shortcode( $atts, $content = null ) {
	
	global $paoc_popup_data, $popupaoc_options;
	
	// Shortcode Parameter
	extract(shortcode_atts(array(
		'id'     		=> 0
	), $atts));

	$id = isset( $id ) ? trim( $id ) : false;

	// If id is not there then return
	if( empty($id) ) {
		return $content;
	}

	// Enqueus required script
	if( empty($popupaoc_options['add_js']) ) {
		wp_enqueue_script('jquery-custombox-legacy');
	}
	wp_enqueue_script('jquery-custombox');
	wp_enqueue_script('wpos-public-script-js');

	// Taking some variables
	$prefix = POPUPAOC_META_PREFIX; // Metabox prefix

	// Getting post data
	$post_data = get_post($id);
	$unique = popupaoc_get_unique();

	ob_start();
	// If it is button post type and post is publish
	if(isset($post_data->post_type) && $post_data->post_type == POPUPAOC_POST_TYPE && $post_data->post_status == 'publish') {

		// Getting button type
		$image_title 			= '';
		$image_caption 			= '';
		$image_alt 				= '';
		$popup_type 			= get_post_meta( $id, $prefix.'popup_type', true );
		$popup_link_txt 		= get_post_meta( $id, $prefix.'popup_link_txt', true );
		$popup_button_txt 		= get_post_meta( $id, $prefix.'popup_button_txt', true );
		$popup_image_url 		= get_post_meta( $id, $prefix.'popup_image_url', true );
		$popup_image_title 		= get_post_meta( $id, $prefix.'image_title', true );
		$popup_image_caption 	= get_post_meta( $id, $prefix.'image_caption', true );		
		$full_screen 			= get_post_meta( $id, $prefix.'full_screen', true );
		$enable_loader 			= get_post_meta( $id, $prefix.'enable_loader', true );
		$enable_ovelay 			= get_post_meta( $id, $prefix.'enable_ovelay', true );
		$popup_effect 			= get_post_meta( $id, $prefix.'popup_effect', true );
		$popup_positionx 		= get_post_meta( $id, $prefix.'popup_positionx', true );
		$popup_positiony 		= get_post_meta( $id, $prefix.'popup_positiony', true );
		$popupwidth 			= get_post_meta( $id, $prefix.'popupwidth', true );
		$speedin 				= get_post_meta( $id, $prefix.'speedin', true );
		$speedout 				= get_post_meta( $id, $prefix.'speedout', true );
		$delay 					= get_post_meta( $id, $prefix.'delay', true );
		$attachment_id 			= get_post_meta( $id, $prefix.'popup_image_id', true );

		if(empty($popupwidth)){ $popupwidth = "60%"; }
		if($full_screen == "true") { $popupwidth = "100%"; }
		if(empty($speedin)){ $speedin = 300; }
		if(empty($speedout)){ $speedout = 300; }
		if(empty($delay)){ $delay = 150; }

		$popup_content 			= do_shortcode( wpautop($post_data->post_content) );

		// Assigning it into global var
		$paoc_popup_data[ $unique ] = $popup_content;

		// Creating Popup Configuration	
		$data_popupaoc_str = '{"content":';
		$data_popupaoc_str .= '{ "target" : "#paoc-modal-'.$unique.'", "effect": "'.$popup_effect.'", "positionX": "'.$popup_positionx.'", "positionY": "'.$popup_positiony.'", "fullscreen": '.$full_screen.', "speedIn": '.$speedin.', "speedOut": '.$speedout.', "delay": '.$delay.', "width": "'.$popupwidth.'" },';
		$data_popupaoc_str .= '"loader":';
		$data_popupaoc_str .= '{"active": '.$enable_loader.'},';
		$data_popupaoc_str .= '"overlay":';	
		$data_popupaoc_str .= '{"active": '.$enable_ovelay.'}';	
		$data_popupaoc_str .= '}';

		// get image title and caption
		$attachment_url 		= $popup_image_url;
		if( $attachment_id ) {
			$attachment 			= get_post( $attachment_id );
			$attachment_image_alt	= get_post_meta( $attachment_id, '_wp_attachment_image_alt', true);

			$image_title 	= $attachment->post_title;
			$image_caption 	= $attachment->post_excerpt;
			$image_alt		= !empty($attachment_image_alt) ? $attachment_image_alt : '';
		}

		// If it is a simple button
		if($popup_type == 'simple_link') { ?>
			<a class="paoc-popup popupaoc-link" href="javascript:void(0);" data-target="popuppaoc-modal-<?php echo $id; ?>" data-conf='<?php echo $data_popupaoc_str;?>'><?php echo $popup_link_txt;?></a>
		<?php }
		elseif($popup_type == 'image'){	?>
			<div class="popupaoc-image-popup">
				<a class="paoc-popup popupaoc-link-image" href="javascript:void(0);" data-target="popuppaoc-modal-<?php echo $id; ?>" data-conf='<?php echo $data_popupaoc_str;?>'><img class="popupaoc-img" src="<?php echo esc_url($popup_image_url);?>" alt="<?php echo esc_attr($image_alt); ?>" /></a>
				<?php if($popup_image_title == 'true' && $image_title){ ?>
					<h4 class="popupaoc-image-title"><?php echo esc_html($image_title); ?></h4>
				<?php }
				if($popup_image_caption == 'true' && $image_caption){ ?>
					<div class="popupaoc-image-caption"><?php echo esc_html($image_caption); ?></div>
				<?php } ?>
			</div>	
		<?php } else { ?>
			<a class="paoc-popup popupaoc-button" href="javascript:void(0);" data-target="popuppaoc-modal-<?php echo $id; ?>" data-conf='<?php echo $data_popupaoc_str;?>'><?php echo $popup_button_txt;?></a>
	<?php }
	}
	$content .= ob_get_clean();
	return $content;
	
}
// 'popup_anything' shortcode
add_shortcode('popup_anything', 'popupaoc_popup_anything_shortcode');